### BTBS-LNS: A Binarized-Tightening, Branch and Search Approach of Learning Large Neighborhood Search Policies for MIP

A hybrid approach to learn hybrid branch and search policies for solving general mixed integer programming problems. **Note that the full full training and evaluation code will be released upon acceptance, and the current version is just an example.**

#### 1. Training and testing instances

+ **Binary integer programming problems**
    
    For the four binary integer programming problems, setcover, maxcut, CA, MIS, the instances can be generated as follows:

    ```python
    python 01_generate_instances.py maxcut # Maximum Cut problem
    python 01_generate_instances.py cats # Combinatorial Cuction problem
    python 01_generate_instances.py indset # Minimum Independent Set problem 
    python 01_generate_instances.py setcover #Setcover problem
    ```

    The results can be directly saved in data/instances. Note that the variable and constraint sizes can directly refer to Table 8 in Appendix, which is also the same as [1] to make fair comparison with RL-LNS. Note that if you want to generate testing samples by yourself, some hyperparameters in ```01_generate_instances.py``` should be updated, as the problem sizes need to be decided for the generated instances.

+ **Mixed integer programming problems**

    For Mixed Integer Programming problems (Balanced Item placement and Anonymous MIPLIB). Training and Testing instances can directly refer to [Machine Learning for Combinatorial Optimization (ML4CO) NeurIPS 2021 competition](https://www.ecole.ai/2021/ml4co-competition/). The instances can be directly downloaded from the[Official Website](https://drive.google.com/file/d/1MytdY3IwX_aFRWdoc0mMfDN9Xg1EKUuq/view?usp=sharing).

+ **MIPLIB2017 benchmark set**
  
  In response to the needs of researchers for access to real-world mixed integer programs, Robert E. Bixby, E.A. Boyd, and R.R. Indovina created in 1992 the MIPLIB, an electronically available library of both pure and mixed integer programs. Since its introduction, MIPLIB has become a standard test set used to compare the performance of mixed integer optimizers. Its availability has provided an important stimulus for researchers in this very active area. The Benchmark Set contains 240 instances that are solvable by (the union of) today's codes. For practical reasons, the benchmark instances were selected subject to various constraints regarding solvability and numerical stability. Download the instance sets from the [Download page](https://miplib.zib.de/download.html).




#### 2. Performance evaluation

+ **The proposed BTBS-LNS framework**

    Note that some instances for Maxcut and CA problems are directly saved in ```data/instances/``` for quick testing, and the trained models are already saved in ```models/``` (RL-based LNS policy), ```branching_net\trained_models``` (Local branching variant) and ```branching_net_global\trained_models``` (Global branching variant). The testing results will be saved in ddpg_test_results/. Note that the file "best_bound.csv" is used to calculate the primal integral for each instance. In addidtion, due to the size limit of supplementary materials, testing data for other problems should be generated by yourself.

    ```python
    python test_LNS_branching.py maxcut # Maximum cut problems
    python test_LNS_branching.py cats # Combnatorial Auction problems
    ```

    Note that the code provided above are utilized to test the local branching variant of our proposed framework. You can update the saved model path in ```test_LNS_branching.py``` to further evaluate the global branching variant.

    Note that if you want to test our proposed binarized tightening mechanism, you can directly test as follows:
    ```python
    python test_LNS_integer.py maxcut # Maximum cut problems
    python test_LNS_integer.py cats # Combnatorial Auction problems
    ```

    Note that the proposed binarized tightening mechanism are more suitable for instances that contained general integer variables, like MIPLIB.


+ **SCIP test**

    The state-of-the-art open source solver SCIP can be tested as follows (Maxcut for an example, others are the same):
    ```python
    python scip.py maxcut
    ```
+ **Gurobi test**

    The state-of-the-art commercial solver Gurobi can be tested as follows (Maxcut for an example, others are the same):
    ```
    python gurobi.py maxcut
    ```

+ **RL_LNS and U-LNS test**
    We directly refer to the implementation from [Learning Large Neighborhood Search Policy for Integer Programming](https://github.com/WXY1427/Learn-LNS-policy)


+ **R_LNS and FT_LNS test**
    We also directly refer to the implementation by [A General Large Neighborhood Search Framework for Solving Integer Programs](https://colab.research.google.com/drive/1-vtfDzHFHuLmAz7fwIlZvLjk4MtatxYn?usp=sharing).

+ **RENS, DINS, GINS and RINS test**

    The four heuristic-based approaches are tested with SCIP implementation as follows (RINS for an example):

    ```python
    python test_LNS_SCIP.py
    ```

    Other testing can be obtained by updating Line 87-90 in ```test_LNS_SCIP.py```. The implementation can directly refer to [Adaptive large neighborhood search for mixed integer programming](https://www.scipopt.org/), as all the variants have already been implemented in SCIP as primal heuristics.

+ **Branching test**
  
  The branching baseline proposed by [4] doesn’t have open-source code and some hyperparameters are difficult to finetune in different MIP problems. However, in order to further evaluate our proposed framework with pure local branching based methods, we try to reproduce them. Some reproduction details are as follows:
  
  + For fair comparison, we replace the neural diving in [4] with an initial feasible solution generated by SCIP, the same as our approach.
  + In data collection, the desired Hamming radius $\eta_t$ are selected as $50$, the same as our branching policy.
  + The model structure were the same as its descriptions, where we use the code provided by [Reference [5]: Exact combinatorial optimization with graph convolutional neural networks](https://github.com/ds4dm/learn2branch), and additionally use a fixed-size window ($3$ in the paper) of past variable assignments as variable features.
  + Loss function and training were all respect to the settings in the paper.
  + In the inference phase with the learned policy, we performed the same action sampling mechanism as in [4]. As for the adaptive neighborhood size, we start with 10\% of the integer variable size, and the dynamic factor $a$ was tuned from $1.01$ to $1.05$. Best-performing parameters will be selected for comparison in each problem. As a result, on SC and MIS, $a$ was set as $1.02$, and $a=1.03$ can deliver the best performance on other problems.
  + Note that the branching variant has already been implemented in ```test_Branching.py```, you can also directly test the branching baseline as follows:
  
    ```python
    python test_Branching.py maxcut
    ```
  + The trained models have already saved in ```branching/```;


#### 3. Experiments with Gurobi

In this section, we want to illustrate the details on how our proposed framework can transfer to Gurobi version, where the commercial solver Gurobi was utilized to serve as the baseline solver.

Note that the training should be performed separately with Gurobi as the baseline solver. Considering that Gurobi is a commercial solver and offers less interfaces to the internal solving process. We directly extract related features from SCIP and utilize Gurobi only as the off-the-shelf solver. Note that the feature extraction time are included in the test phase for fair comparison.

+ **Static feature extraction**
    ```
    python collect_data.py item
    ```

    The generated feature files will be saved in ```collect/```. It will generate a single feature file for each instance, which will be used as the input features for Gurobi version of our BTBS-LNS.

+ **Test with Gurobi**
    ```
    python test_LNS_gurobi.py item
    ```
    It will collect feature samples from the ```collect/``` path, and the time for generating feature samples will also be incorporated in the testing phase  for fair comparison.

    Note that other baselines can test with Gurobi with the same handling.

#### 4. Installation requirements

SCIP, SoPlex and pyscipopt can directly refer to https://github.com/ds4dm/learn2branch

Others requirements can directly refer to requirements.txt


#### 5. Other files illustration

+ **analysis_miplib.py**
  Analyze the MIPLIB instances on the counts of instances that contained unbounded general integer variables before and after the presolve.
+ **test_miplib.py**
  Analyze the variable and constraints of MIPLIB2017 instances and Annoymous MIPLIB instances.


### References

[1] Wu, Yaoxin, et al. "Learning large neighborhood search policy for integer programming." Advances in Neural Information Processing Systems 34 (2021): 30075-30087.

[2] Song, Jialin, Yisong Yue, and Bistra Dilkina. "A general large neighborhood search framework for solving integer linear programs." Advances in Neural Information Processing Systems 33 (2020): 20012-20023.

[3] Hendel, Gregor. "Adaptive large neighborhood search for mixed integer programming." Mathematical Programming Computation (2022): 1-37.

[4] Sonnerat, Nicolas, et al. "Learning a large neighborhood search algorithm for mixed integer programs." arXiv preprint arXiv:2107.10201 (2021).

[5] Gasse, Maxime, et al. "Exact combinatorial optimization with graph convolutional neural networks." Advances in neural information processing systems 32 (2019).